const { sendErrorResponse, sendResponse } = require("../utils/index.js");
const tables = require("../utils/tables.js");
const { performQuery } = require("../utils/db.js");

module.exports.getSystems = async (req, res) => {
  try {
    const selectSystemQuery = `SELECT * FROM ${tables.system} where is_active = 1 Order By id ASC`;
    // Perform the database query
    const system = await performQuery(selectSystemQuery);
    return sendResponse(
      res,
      system,
      "Fetch System data successfully",
      200
    );
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fetching System");
  }
};
