const { performQuery } = require("../utils/db");
const tables = require("../utils/tables");
const moment = require("moment-timezone");

module.exports.getSystemTime = async () => {
    try {
        const query = `SELECT * FROM ${tables.setting} `;
        const data = await performQuery(query,[]);
        if (!data) {
          return null
        }
        
        const timezone = data[0].region;
        const systemTime = moment().tz(timezone);
        
        return systemTime;

      } catch (error) {
        console.log("Failed to retrieve frequency", error);
        return null
      }
}


module.exports.getTimezone = async () => {
  try {
    const query = `SELECT * FROM ${tables.setting} `;
    const data = await performQuery(query, []);
    if (!data) {
      return null;
    }

    const timezone = data[0].region;

    return timezone;
  } catch (error) {
    console.log("Failed to retrieve System Time", error);
    return error;
  }
};
