const multer = require("multer");
const path = require("path");

const excelFilter = (req, file, cb) => {
  if (
    file.mimetype.includes("excel") ||
    file.mimetype.includes("spreadsheetml")
  ) {
    cb(null, true);
  } else {
    cb("Please upload only excel file.", false);
  }
};

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    // cb(null, __basedir + "uploads");
    cb(null, "uploads");
  },
  filename: (req, file, cb) => {
    console.log("file.originalname >>", file.originalname);
    cb(
      null,
      // file.fieldname + "-" + Date.now() + path.extname(file.originalname)
      file.fieldname + "-" + `${Date.now()}-pa-${file.originalname}`
    );
  },
});

const uploadFile = multer({ storage: storage, fileFilter: excelFilter });
module.exports = uploadFile;
