const router = require("express").Router();
const authController = require("../controllers/auth.controller");

router.post("/signup", authController.signUp);
router.post("/login", authController.login);
router.post("/set-password", authController.setPassword);
router.put("/change-password", authController.changePassword);
router.post("/forgot-password", authController.forgotPassword);
router.post("/reset-password", authController.resetPassword);

module.exports = router;
