const router = require("express").Router();
const departmentController = require("../controllers/department.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.get("/", departmentController.getDepartments);
router.post("/", adminAuth, departmentController.createDepartment);
router.put("/", adminAuth, departmentController.updateDepartment);
router.delete("/", adminAuth, departmentController.deleteDepartment);

module.exports = router;
