const { getDesignations, createDesignation, updateDesignation, deleteDesignation } = require("../controllers/designation.controller");
const { adminAuth } = require("../middleware/authMiddleware");

const router = require("express").Router();

router.post("/", adminAuth, createDesignation);
router.put("/", adminAuth, updateDesignation);
router.get("/", getDesignations);
router.delete("/", adminAuth, deleteDesignation);

module.exports = router;
