const router = require("express").Router();
const equipmentController = require("../controllers/equipment.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.post("/", adminAuth, equipmentController.createEquipment);
router.put("/", adminAuth, equipmentController.updateEquipment);
router.get("/", equipmentController.getEquipments);
router.delete("/", adminAuth, equipmentController.deleteEquipment);

module.exports = router;
