const router = require("express").Router();
const lineController = require("../controllers/line.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.post("/", adminAuth, lineController.createLine);
router.put("/", adminAuth, lineController.updateLine);
router.get("/", lineController.getLines);
router.delete("/", adminAuth, lineController.deleteLine);

module.exports = router;
