const router = require("express").Router();
const productController = require("../controllers/product.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.get("/", productController.getProducts);
router.post("/", adminAuth, productController.createProduct);
router.put("/", adminAuth, productController.updateProduct);
router.delete("/", adminAuth, productController.deleteProduct);

module.exports = router;
