const router = require("express").Router();
const { authMiddleware } = require("../middleware");
const userRouter = require("./user.route.js");
const authRouter = require("./auth.route.js");
const departmentRouter = require("./department.route.js");
const lineRouter = require("./line.route.js")
const equipmentRouter = require("./equipment.route.js")
const subEquipmentRouter = require("./subEquipment.route.js")
const productRouter = require("./product.route.js")

const shiftRouter = require("./shift.route.js")
const unitRouter = require("./unit.route.js")
const teamRouter = require("./team.route.js")
const designationRouter = require("./designation.route.js")
const orderRouter = require("./order.route.js")
const systemsRouter = require("./system.route.js")

router.use("/auth", authRouter);
router.use("/user", userRouter);
router.use("/department", departmentRouter);
router.use("/line", lineRouter);
router.use("/equipment", equipmentRouter);
router.use("/subEquipment", subEquipmentRouter);
router.use("/product", productRouter);

router.use("/shift", shiftRouter);
router.use("/unit", unitRouter);
router.use("/team", teamRouter);
router.use("/designation", designationRouter);
router.use("/order", orderRouter);
router.use("/system", systemsRouter);

module.exports = router;
