const router = require("express").Router();
const shiftController = require("../controllers/shift.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.post("/", adminAuth, shiftController.createShift);
router.put("/", adminAuth, shiftController.updateShift);
router.get("/", shiftController.getShifts);
router.delete("/", adminAuth, shiftController.deleteShift);

module.exports = router;
