const router = require("express").Router();
const subEquipmentController = require("../controllers/subEquipment.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.post("/", adminAuth, subEquipmentController.createSubEquipment);
router.put("/", adminAuth, subEquipmentController.updateSubEquipment);
router.get("/", subEquipmentController.getSubEquipments);
router.delete("/", adminAuth, subEquipmentController.deleteSubEquipment);

module.exports = router;
