const { getTeams, getTeam, createTeam, updateTeam, deleteTeam } = require("../controllers/team.controller");
const { adminAuth } = require("../middleware/authMiddleware");

const router = require("express").Router();

router.post("/", adminAuth, createTeam);
router.put("/", adminAuth, updateTeam);
router.get("/", getTeams);
router.delete("/", adminAuth, deleteTeam);

module.exports = router;
