const { getUnits, getUnit, createUnit, updateUnit, deleteUnit } = require("../controllers/unit.controller");
const { adminAuth } = require("../middleware/authMiddleware");

const router = require("express").Router();

router.post("/", adminAuth, createUnit);
router.put("/", adminAuth, updateUnit);
router.get("/", getUnits);
router.delete("/", adminAuth, deleteUnit);

module.exports = router;
