const router = require("express").Router();
const userController = require("../controllers/user.controller");
const { adminAuth } = require("../middleware/authMiddleware");

router.post("/", adminAuth, userController.createUser);
router.put("/", adminAuth, userController.updateUser);
router.get("/", userController.getUsers);
router.delete("/", adminAuth, userController.deleteUser);

module.exports = router;
