const mysql = require("mysql2");
const { DB_HOST, DB_USER, DB_PASSWORD } = require("../config");

const pool = mysql.createPool({
  host: DB_HOST,
  user: DB_USER,
  password: DB_PASSWORD,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
  enableKeepAlive: true,
  keepAliveInitialDelay: 10000,
});

// Wraps the pool.getConnection() function
function getConnection() {
  return new Promise((resolve, reject) => {
    pool.getConnection((err, connection) => {
      if (err) {
        reject(err);
        return;
      }
      resolve(connection);
    });
  });
}

// Performs a database query using a connection from the pool
async function performQuery(sql, params) {
  const connection = await getConnection();

  try {
    return new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) {
          reject(error);
          return;
        }
        resolve(results);
      });
    });
  } finally {
    connection.release();
  }
}

module.exports = { pool, getConnection, performQuery };